
$(function () {
	$.validator.setDefaults({
		submitHandler: function (form) {
			form.submit();
		}
	});

	$('#js-transaction-form').validate({
		rules: {
			amount: {
				required: true,
				min: 1,
				number: true,
			},
			date: {
				required: true
			},
			method: {
				required: true
			},
		},
		messages: {
			amount: {
				required: "Please enter amount",
				min: "Amount must be greater than zero.",
				number: "Please enter a valid amount"
			},
			date: "Please select transaction date",
			method: "Please select transaction method",
		},
		errorElement: 'span',
		errorPlacement: function (error, element) {
			error.addClass('invalid-feedback');
			element.closest('.form-group').append(error);
		},
		highlight: function (element, errorClass, validClass) {
			$(element).addClass('is-invalid');
		},
		unhighlight: function (element, errorClass, validClass) {
			$(element).removeClass('is-invalid');
		}
	});


	// Update the max rule for the amount input based on the data-max attribute
	$("#amount").rules("add", {
		max: Number($("#amount").data("max")),
		messages: {
			max: "Amount must not be greater than due amount " + $("#amount").data("max")
		}
	});
});
